/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual.features;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.ritual.FeaturePlacementRitual;
import com.hollingsworth.arsnouveau.api.ritual.features.IPlaceableFeature;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BonemealFeature
implements IPlaceableFeature {
    double distance;
    double chance;

    public BonemealFeature(double distance, double chance) {
        this.distance = distance;
        this.chance = chance;
    }

    @Override
    public double distanceFromOthers() {
        return this.distance;
    }

    @Override
    public boolean onPlace(Level level, BlockPos pos, FeaturePlacementRitual placementRitual, RitualBrazierTile brazierTile) {
        ItemStack stack = new ItemStack((ItemLike)Items.BONE_MEAL, 64);
        if ((double)level.random.nextFloat() < this.chance && BoneMealItem.applyBonemeal((ItemStack)stack, (Level)level, (BlockPos)pos.below(), (Player)ANFakePlayer.getPlayer((ServerLevel)level))) {
            if (!level.isClientSide) {
                level.levelEvent(1505, pos.below(), 0);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getFeatureName() {
        return "bonemeal";
    }
}

